#include "Sensor.h"
#include "I2C.h"
#include <avr/io.h>

//Device address
char device_addr = 0x6B << 1;
char device_magn = 0x1E << 1;

void sensor_initCommunication(){
	i2c_initialize();
}

void sensor_initAccel(){
	//ENABLE ACCELEROMETER
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x20);  //accelerometer: reg6
	//i2c_writeByte(0B11011000); //turn on power, 8g
	i2c_writeByte(0B11001000); // 16g
	i2c_sendStopFrame();
}

char sensor_checkAccel(void){
	char dest[1];
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x27); //read register 27
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(1, dest);
	i2c_sendStopFrame();
	if (dest[0] & 0x01){ //first bit is accel available
		return 1;
	}
	else{
		return 0;
	}
}

void sensor_readAccel(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x28); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(6,dest);
	i2c_sendStopFrame();
}

void sensor_readAccelX(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x28); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readAccelY(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x2A); //Register of Y data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readAccelZ(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x2C); //Register of Z data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_initGyro(){
	//ENABLE GYROSCOPE
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x10);  //accelerometer: reg1
	i2c_writeByte(0B11011011); //turn on power + set scale to 2000 dps + 1kHz data rate
	i2c_sendStopFrame();
}

char sensor_checkGyro(void){
	char dest[1];
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x27); //read register 27
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(1, dest);
	i2c_sendStopFrame();
	if (dest[0] & 0x02){ //second bit is gyro available
		return 1;
	}
	else{
		return 0;
	}
}

void sensor_readGyro(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x18); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(6,dest);
	i2c_sendStopFrame();
}

void sensor_readGyroX(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x18); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readGyroY(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x1A); //Register of Y data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readGyroZ(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_addr);
	i2c_writeByte(0x1C); //Register of Z data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_addr);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}



//multiplier for 4 gauss: 0.00014

void sensor_initMagn(){
	//ENABLE ACCELEROMETER
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x20);  //accelerometer: reg6
	i2c_writeByte(0B01111110); // 4gauss
	i2c_sendStopFrame();
	
		i2c_sendStartFrame();
		i2c_selectSlaveWrite(device_magn);
		i2c_writeByte(0x22);  //accelerometer: reg6
		i2c_writeByte(0B00000000); //
		i2c_sendStopFrame();
		
		i2c_sendStartFrame();
		i2c_selectSlaveWrite(device_magn);
		i2c_writeByte(0x23);  //accelerometer: reg6
		i2c_writeByte(0B00001100); //
		i2c_sendStopFrame();
}

char sensor_checkMagn(void){
	char dest[1];
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x27); //read register 27
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_magn);
	i2c_readByte(1, dest);
	i2c_sendStopFrame();
	if (dest[0] & 0x04){ //check data available for all axes
		return 1;
	}
	else{
		return 0;
	}
}

void sensor_readMagn(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x28); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_magn);
	i2c_readByte(6,dest);
	i2c_sendStopFrame();
}

void sensor_readMagnX(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x28); //Register of X data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_magn);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readMagnY(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x2A); //Register of Y data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_magn);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}

void sensor_readMagnZ(char *dest){
	i2c_sendStartFrame();
	i2c_selectSlaveWrite(device_magn);
	i2c_writeByte(0x2C); //Register of Z data
	i2c_sendStartFrameRepeat(); //put into read mode
	i2c_selectSlaveRead(device_magn);
	i2c_readByte(2,dest);
	i2c_sendStopFrame();
}